<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!-- 
		A simple transformation that modifies the request string on an authsvc request
		to remove the need to supply the larger prefix on the PolicyId.
		
		Such that a request to authsvc can look like:
		https://<webseal>/mga/sps/authsvc?PolicyId=recaptcha
		instead of:
		https://<webseal>/mga/sps/authsvc?PolicyId=urn:ibm:security:authentication:asf:recaptcha
		
		Activated in webseal config with:
		
		================
		[http-transformations]
		addconstanttoauthsvc = RemoveAuthsvcConstantprefix.xsl
		
		[http-transformations:addconstanttoauthsvc]
		request-match = request:GET /mga/sps/authsvc?*PolicyId=*
		=============
		Uses an XSLT 1.0 string replace snippet from:
		From: https://stackoverflow.com/questions/3067113/xslt-string-replace/3067130#3067130 
	-->
	
	
	
	
	<!-- Firstly, strip any space elements -->
	<xsl:strip-space elements="*" />
	<!--
		Perform a match on the root of the document. Output the required
		HTTPRequestChange elements and then process templates.
	-->
	<xsl:template match="/">
		<HTTPRequestChange>
			<xsl:apply-templates />
		</HTTPRequestChange>
	</xsl:template>

	<!--
		Match on the URI. Any URI processing should happen within this
		template.
	-->
	<xsl:template match="//HTTPRequest/RequestLine/URI">
		<xsl:variable name="uri" select="/HTTPRequest/RequestLine/URI" />
    	<xsl:choose>
  			<xsl:when test="contains($uri, '?') and contains($uri, 'PolicyId=') and not(contains($uri, 'PolicyId=urn:ibm:security:authentication:asf:'))">
  				<xsl:variable name="output">
         			<xsl:call-template name="string-replace-all">
            			<xsl:with-param name="text" select='$uri' />
            			<xsl:with-param name="replace" select="'PolicyId='" />
            			<xsl:with-param name="by" select="'PolicyId=urn:ibm:security:authentication:asf:'" />
         			</xsl:call-template>
      			</xsl:variable>
  				<!-- Process the URI output here. Output should be in the form required. -->
  				<URI><xsl:value-of select="$output" /></URI>
  			</xsl:when>
  		</xsl:choose>

	</xsl:template>
	
	<!-- 
		A XSLT 1.0 template for replacing strings. 
		From: https://stackoverflow.com/questions/3067113/xslt-string-replace/3067130#3067130 
	-->
	<xsl:template name="string-replace-all">
      <xsl:param name="text" />
      <xsl:param name="replace" />
      <xsl:param name="by" />
      <xsl:choose>
         <xsl:when test="contains($text, $replace)">
            <xsl:value-of select="substring-before($text,$replace)" />
            <xsl:value-of select="$by" />
            <xsl:call-template name="string-replace-all">
               <xsl:with-param name="text" select="substring-after($text,$replace)" />
               <xsl:with-param name="replace" select="$replace" />
               <xsl:with-param name="by" select="$by" />
            </xsl:call-template>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$text" />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
</xsl:stylesheet>
